/*!
 * @file        apm32f4xx_int.c
 *
 * @brief       Main Interrupt Service Routines
 *
 * @version     V1.0.0
 *
 * @date        2022-05-25
 *
 */

#include "apm32f4xx_int.h"
#include "usbh_interrupt.h"
#include "usb_user.h"
#include "Board.h"
#include "usbh_class_cdc.h"

/** @addtogroup Peripherals_Library Standard Peripheral Library
  @{
*/

/** @addtogroup IT_Driver IT Driver
  @{
*/

/** @addtogroup IT_Fuctions Fuctions
  @{
*/

/*!
 * @brief   This function handles NMI exception
 *
 * @param   None
 *
 * @retval  None
 *
 */
void NMI_Handler(void)
{
}

/*!
 * @brief   This function handles Hard Fault exception
 *
 * @param   None
 *
 * @retval  None
 *
 */
void HardFault_Handler(void)
{
    /** Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {
    }
}

/*!
 * @brief   This function handles Memory Manage exception
 *
 * @param   None
 *
 * @retval  None
 *
 */
void MemManage_Handler(void)
{
    /** Go to infinite loop when Memory Manage exception occurs */
    while (1)
    {
    }
}

/*!
 * @brief   This function handles Bus Fault exception
 *
 * @param   None
 *
 * @retval  None
 *
 */
void BusFault_Handler(void)
{
    /** Go to infinite loop when Bus Fault exception occurs */
    while (1)
    {
    }
}
/*!
 * @brief   This function handles Usage Fault exception
 *
 * @param   None
 *
 * @retval  None
 *
 */
void UsageFault_Handler(void)
{
    /** Go to infinite loop when Usage Fault exception occurs */
    while (1)
    {
    }
}

/*!
 * @brief   This function handles SVCall exception
 *
 * @param   None
 *
 * @retval  None
 *
 */
void SVC_Handler(void)
{
}

/*!
 * @brief   This function handles Debug Monitor exception
 *
 * @param   None
 *
 * @retval  None
 *
 */
void DebugMon_Handler(void)
{
}

/*!
 * @brief   This function handles PendSV_Handler exception
 *
 * @param   None
 *
 * @retval  None
 *
 */

void PendSV_Handler(void)
{
}

/*!
 * @brief   This function handles SysTick Handler
 *
 * @param   None
 *
 * @retval  None
 *
 */
void SysTick_Handler(void)
{
}

/*!
 * @brief   This function handles USB FS or HS Handler
 *
 * @param   None
 *
 * @retval  None
 *
 */
#ifdef USB_OTG_FS
void OTG_FS_IRQHandler(void)
#else
void OTG_HS1_IRQHandler(void)
#endif
{
    USBH_OTG_IsrHandler();
}

/*!
 * @brief   This function handles TMR2 Handler
 *
 * @param   None
 *
 * @retval  None
 *
 */
void TMR2_IRQHandler(void)
{
    USB_Timer_IRQHandler();
}

/*!
 * @brief   This function handles External line 0 Handler
 *
 * @param   None
 *
 * @retval  None
 *
 */
void EINT0_IRQHandler(void)
{
    if(EINT_ReadIntFlag(EINT_LINE_0))
    {
        APM_EVAL_LEDToggle(LED2);
        if(!GPIO_ReadInputBit(LED2_GPIO_PORT, LED2_PIN))
        {
            /** send data to cdc device */
            if(CDC_SendData(cdcDataOutBuff, 64))
            {
                printf(">> Buffer to send: %s\n",cdcDataOutBuff);
            }
        }
        else
        {
        }
        /**Clear EINT_LINE0 interrupt flag*/
        EINT_ClearIntFlag(EINT_LINE_0);
    }
}

/*!
 * @brief   This function handles External lines 1 Handler
 *
 * @param   None
 *
 * @retval  None
 *
 */
void EINT1_IRQHandler(void)
{
    if(EINT_ReadIntFlag(EINT_LINE_1))
    {
        APM_EVAL_LEDToggle(LED3);
        if(!GPIO_ReadInputBit(LED3_GPIO_PORT, LED3_PIN))
        {
            /** enable cdc get data */
            CDC_EnableGet();
            printf(">> Enable CDC Get data.\n");
        }
        else
        {
            /** disable cdc get data */
            CDC_DisableGet();
            printf(">> Disable CDC Get data\n");
        }
        /**Clear EINT_LINE0 interrupt flag*/
        EINT_ClearIntFlag(EINT_LINE_1);
    }
}

/**@} end of group IT_Fuctions*/
/**@} end of group IT_Driver*/
/**@} end of group Peripherals_Library*/

